<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
Route::post('login', function (Request $request) {
    
    if (auth()->attempt(['email' => $request->input('email'), 'password' => $request->input('password')])) {
        // Authentication passed...
        $user = auth()->user();
        $user->api_token = str_random(60);
        $user->save();
        return $user;
    }
    
    return response()->json([
        'error' => 'Unauthenticated user',
        'code' => 401,
        'email' => $request->input('email'),
        'password' => $request->input('password'),  
    ], 401);
});
Route::group(['middleware' => ['api','cors']], function () {
    Route::post('auth/register', 'Auth\ApiRegisterController@create');
    Route::post('password/email', 'Auth\ForgotPasswordController@getResetToken');
});

Route::group(['prefix' => 'v1'], function () {
    Route::get('/usermeta', 'UserMetaController@index');
	Route::get('/experience', 'Experience\experienceController@index');
	Route::get('/poi', 'Experience\poiController@index');
	Route::get('/question', 'Experience\questionController@index');
	Route::get('/languages', 'Experience\langController@index');
	
	Route::group(['middleware' => 'auth:api'], function () {
	});

	});
Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});
