<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class questions extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'manage_questions';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'num';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [ 'poi_id', 'question', 'answer_type', 'no_answers', 'options', 'correct_answers'];

    public function poi()
    {
        return $this->belongsTo('App\poi','poi_id');
    }  
    public function options()
    {
        return $this->hasMany('App\answers', 'question_id');
    }
   function correct_answers()
    {
        return $this->hasMany('App\correctanswers', 'question_id');
    }
}
