<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class poisocials extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'manage_poi_social';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'social_id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['poi_id', 'social_id', 'share_url'];

    public function poi()
    {
        return $this->belongsTo('App\poi','poi_id');
    }
    
    public function links()
    {
        return $this->hasMany('App\poisociallinks','num');
    }
    
    protected static function boot()
    {
        parent::boot();
     
        // Order by name ASC
        static::addGlobalScope('order', function (Builder $builder) {
            $builder->orderBy('num', 'asc');
        });
    }
}
