<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class poi extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'manage_eb_poi';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'num';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['user_id', 'Name', 'sub_title', 'short_desc', 'description', 'thumbnail', 'place_address', 'audio_file', 'audio_duration', 'video_file', 'video_duration', 'latitude', 'longitude', 'intro_id','sort_order','total_images','map_pin','poi_images','radius','n_message','experience'];
    
    public function experience()
    {
        return $this->belongsTo('App\experience','intro_id');
    }
    
    public function poi_aug()
    {
        return $this->hasMany('App\poiaug','poi_id');
    }
    
    public function poi_beacon()
    {
        return $this->hasMany('App\beacon','poi_id');
    }
    
    public function poi_questions()
    {
        return $this->hasMany('App\questions','poi_id');
    }
    
    public function poi_images()
    {
        return $this->hasMany('App\poiimages','poi_id');
    }
    
    public function poi_socials()
    {
        return $this->hasMany('App\poisocials','poi_id');
    }
    
    protected static function boot()
    {
        parent::boot();
     
        // Order by name ASC
        static::addGlobalScope('order', function (Builder $builder) {
            $builder->orderBy('Name', 'asc');
        });
    }
}
