<?php

namespace App\Http\Controllers\Experience;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\poi;
use App\experience;
use Illuminate\Http\Request;

class poiController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index(Request $request)
    {
        $keyword = $request->get('search');
        $perPage = 25;

        if (!empty($keyword)) {
            $poi = poi::with('experience')->paginate($perPage);
        } else {
            $poi = poi::with('experience')->paginate($perPage);
        }
        return $poi ;
        // return view('experience.index', compact('experience'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('poi.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        $this->validate($request, [
			'category_id' => 'required',
			'topic_id' => 'required',
			'location_id' => 'required'
		]);
        $requestData = $request->all();
        
        poi::create($requestData);

        return redirect('tour/poi')->with('flash_message', 'poi added!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     *
     * @return \Illuminate\View\View
     */
    public function show($id)
    {
        $poi = poi::findOrFail($id);

        return view('poi.show', compact('poi'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     *
     * @return \Illuminate\View\View
     */
    public function edit($id)
    {
        $poi = poi::findOrFail($id);

        return view('poi.edit', compact('poi'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
			'category_id' => 'required',
			'topic_id' => 'required',
			'location_id' => 'required'
		]);
        $requestData = $request->all();
        
        $poi = poi::findOrFail($id);
        $poi->update($requestData);

        return redirect('tour/poi')->with('flash_message', 'poi updated!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        poi::destroy($id);

        return redirect('tour/poi')->with('flash_message', 'poi deleted!');
    }
}
