<?php

namespace App\Http\Controllers\Experience;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\poi;
use App\experience;
use App\experiencelang;
use App\poilang;
use Illuminate\Http\Request;

class experienceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index(Request $request)
    {
        $keyword = $request->get('search');
        $perPage = 25;
        $lang = null;
        $experience = null ;
       if($request->get('lang-id') && $request->get('lang-id') != "1")
       {
            $lang = $request->get('lang-id');
            if (!empty($keyword)) {
                $experience = experience::with('poi')->orderBy('title' , 'ASC')->with('poi.poi_questions')->with('poi.poi_questions.options')->with('poi.poi_beacon')->with('poi.poi_aug')->with('poi.poi_images')->with('poi.poi_questions.correct_answers')->where('category_id', 'LIKE', "%$keyword%")
    				->orWhere('topic_id', 'LIKE', "%$keyword%")
    				->orWhere('location_id', 'LIKE', "%$keyword%")
    				->orWhere('title', 'LIKE', "%$keyword%")
    				->orWhere('isFav', 'LIKE', "%$keyword%")
    				->orWhere('location', 'LIKE', "%$keyword%")
    				->orWhere('summary', 'LIKE', "%$keyword%")
    				->orWhere('description', 'LIKE', "%$keyword%")
    				->orWhere('cover_image', 'LIKE', "%$keyword%")
    				->orWhere('estimated_duration', 'LIKE', "%$keyword%")
    				->orWhere('donwload_size', 'LIKE', "%$keyword%")
    				->orWhere('poi', 'LIKE', "%$keyword%")
    				->orWhere('user_details', 'LIKE', "%$keyword%")
    				->orWhere('reviews', 'LIKE', "%$keyword%")
    				->paginate($perPage);
            } else {
                $experience = experiencelang::with('poi')->orderBy('title' , 'ASC')->with('poi.poi_questions')->with('poi.poi_beacon')->with('poi.poi_aug')->with('poi.poi_images')->with('poi.poi_questions.options')->with('poi.poi_questions.correct_answers')->where('lang_id', $lang)->paginate($perPage);
            }
       
       }
       else
       {
       // return $lang;
            if (!empty($keyword)) {
                $experience = experience::with('poi')->orderBy('title' , 'ASC')->with('poi.poi_questions')->with('poi.poi_questions.options')->with('poi.poi_beacon')->with('poi.poi_aug')->with('poi.poi_images')->with('poi.poi_questions.correct_answers')->where('category_id', 'LIKE', "%$keyword%")
    				->orWhere('topic_id', 'LIKE', "%$keyword%")
    				->orWhere('location_id', 'LIKE', "%$keyword%")
    				->orWhere('title', 'LIKE', "%$keyword%")
    				->orWhere('isFav', 'LIKE', "%$keyword%")
    				->orWhere('location', 'LIKE', "%$keyword%")
    				->orWhere('summary', 'LIKE', "%$keyword%")
    				->orWhere('description', 'LIKE', "%$keyword%")
    				->orWhere('cover_image', 'LIKE', "%$keyword%")
    				->orWhere('estimated_duration', 'LIKE', "%$keyword%")
    				->orWhere('donwload_size', 'LIKE', "%$keyword%")
    				->orWhere('poi', 'LIKE', "%$keyword%")
    				->orWhere('user_details', 'LIKE', "%$keyword%")
    				->orWhere('reviews', 'LIKE', "%$keyword%")
    				->paginate($perPage);
            } else {
                $experience = experience::with('poi')->orderBy('title' , 'ASC')->with('poi.poi_questions')->with('poi.poi_beacon')->with('poi.poi_aug')->with('poi.poi_images')->with('poi.poi_socials')->with('poi.poi_socials.links')->with('poi.poi_questions.options')->with('poi.poi_questions.correct_answers')->paginate($perPage);
            }
       }
        return $experience ;
        // return view('experience.index', compact('experience'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('experience.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        $this->validate($request, [
			'category_id' => 'required',
			'topic_id' => 'required',
			'location_id' => 'required'
		]);
        $requestData = $request->all();
        
        experience::create($requestData);

        return redirect('tour/experience')->with('flash_message', 'experience added!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     *
     * @return \Illuminate\View\View
     */
    public function show($id)
    {
        $experience = experience::findOrFail($id);

        return view('experience.show', compact('experience'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     *
     * @return \Illuminate\View\View
     */
    public function edit($id)
    {
        $experience = experience::findOrFail($id);

        return view('experience.edit', compact('experience'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
			'category_id' => 'required',
			'topic_id' => 'required',
			'location_id' => 'required'
		]);
        $requestData = $request->all();
        
        $experience = experience::findOrFail($id);
        $experience->update($requestData);

        return redirect('tour/experience')->with('flash_message', 'experience updated!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        experience::destroy($id);

        return redirect('tour/experience')->with('flash_message', 'experience deleted!');
    }
}
