<?php

namespace App\Http\Controllers\Auth;

use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Requests;
use Illuminate\Http\Request;
use Exception;
use Illuminate\Database\QueryException;
class ApiRegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;
    /*
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    protected function registered(Request $request, $user)
    {
	    $user->api_token = str_random(60);
        $user->save();
        return response()->json(['data' => $user->toArray()], 201);
    }

/**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    protected function create(Request $request)
    {
	$data = $request->all();
	 try 
	 {
	     //TODO CECK OT USER EXITS
        $user =  User::create([
            'first_name' => $data['first_name'],
            'surname' => $data['surname'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
	 }
	 catch (QueryException $e){
        $errorCode = $e->errorInfo[1];
        if($errorCode == 1062){
        // houston, we have a duplicate entry problem
        return response()->json(['status'=>'error','message'=>'User Already Exists'], 401);
        }
        return response()->json(['status'=>'error','message'=>'Something went wrong try sometime later'], 401);
        
        }
        catch (Exception $e)
        {
            return response()->json(['status'=>'error','message'=>'Something went wrong try sometime later'], 401);
        }

        $user->api_token = str_random(60);
        $user->save();
        return $user ;
    }

    protected function validator(array $data)
    {
        return Validator::make($data, [
            'first_name' => 'required|string|max:255',
            'surname' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:6|confirmed',
        ]);
    }

}
