<?php
include('includes/config.php');
include('includes/session.php');
include('includes/function.php');

$dir = "uploads/poi/aug/*.*"; // where and what files to operate on 
$files = glob($dir);
foreach($files as $file){
	if($file != $ren = str_replace(" ","_",$file)){
		// there was a space
		rename($file,$ren);
		echo "Renaming: [$file] to [$ren]<br />";
	}
}

$session = new Session();
$database = new Database();
//echo $session->get(SESSION_PREFFIX.'isloggedin');
?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="description" content="A fully featured admin theme which can be used to build CRM, CMS, etc.">
		<meta name="author" content="Coderthemes">

		<link rel="shortcut icon" href="assets/images/favicon_1.ico">

		<title><?php echo WEBSITE_TITLE;?></title>

		<link href="<?php echo CMS_ROOT;?>assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo CMS_ROOT;?>assets/css/core.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo CMS_ROOT;?>assets/css/components.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo CMS_ROOT;?>assets/css/icons.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo CMS_ROOT;?>assets/css/pages.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo CMS_ROOT;?>assets/css/responsive.css" rel="stylesheet" type="text/css" />

        <!-- HTML5 Shiv and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
        <![endif]-->

        <script src="<?php echo CMS_ROOT;?>assets/js/modernizr.min.js"></script>

	</head>
	<body>
<input type="hidden" name="siteurl" id="siteurl" value="<?php echo CMS_ROOT;?>">
        <div class="animationload">
            <div class="loader"></div>
        </div>

		<div class="account-pages"></div>
		<div class="clearfix"></div>
		<div class="wrapper-page">
			<div class=" card-box">
				<div class="panel-heading">
					<h3 class="text-center"> Reset Password </h3>
				</div>

				<div class="panel-body">
					<?php if(!empty($_REQUEST['forgotuemail'])) {?>
					<form method="post" action="#" role="form" class="text-center" name="forgotpassform" id="forgotpassform" data-parsley-validate novalidate>
						<input type="hidden" name="action" value="forgotpass">
                        <input type="hidden" name="forgotuemail" id="forgotuemail" value="<?php echo str_replace(" ","+",$_REQUEST['forgotuemail']);?>">
                        <div class="alert alert-info alert-dismissable">
							<button type="button" class="close" data-dismiss="alert" aria-hidden="true">
								×
							</button>
							Enter your new <b>Password</b>
						</div>
						<div class="form-group m-b-0">
							<div class="form-group ">
                            	<div class="col-xs-12">
								<input type="password" name="forgotpass" id="forgotpass" class="form-control" placeholder="Enter New Password" required="">
                                </div>
							</div><br clear="all">
                            <div class="form-group m-t-20">
                            	<div class="col-xs-12">
								<input type="password" data-parsley-equalto="#forgotpass" name="forgotpass1" id="forgotpass1" class="form-control" placeholder="Confirm New Password" required="">
                                </div>
							</div><br clear="all">
                            <div class="form-group text-center m-t-20">
                            	<div class="col-xs-12">
								<span class="input-group-btn">
									<button type="submit" class="btn btn-pink w-sm waves-effect waves-light">
										Submit
									</button> 
								</span>
                                </div>
							</div>
						</div>
                        <br clear="all">
                        <div class="alert alert-danger alert-dismissable" style="display:none;">
							<button type="button" class="close" data-dismiss="alert" aria-hidden="true">
								×
							</button>
							<span class="msg"></span>
						</div>

					</form>
					<?php } else {?>
                    <form method="post" action="#" role="form" class="text-center" name="forgotpassform" id="forgotpassform">
						<input type="hidden" name="action" value="forgotemail">
                        <div class="alert alert-info alert-dismissable">
							<button type="button" class="close" data-dismiss="alert" aria-hidden="true">
								×
							</button>
							Enter your <b>Email</b> and instructions will be sent to you!
						</div>
						<div class="form-group m-b-0">
							<div class="input-group">
								<input type="email" name="forgotemail" id="forgotemail" class="form-control" placeholder="Enter Email" required="">
								<span class="input-group-btn">
									<button type="submit" class="btn btn-pink w-sm waves-effect waves-light">
										Reset
									</button> 
								</span>
							</div>
						</div>
                        <div class="alert alert-danger alert-dismissable" style="display:none;">
							<button type="button" class="close" data-dismiss="alert" aria-hidden="true">
								×
							</button>
							<span class="msg"></span>
						</div>

					</form>
                    <?php } ?>
				</div>
			</div>
			

		</div>

		<script>
			var resizefunc = [];
		</script>

		<!-- jQuery  -->
        <script src="<?php echo CMS_ROOT;?>assets/js/jquery.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>assets/js/bootstrap.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>assets/js/detect.js"></script>
        <script src="<?php echo CMS_ROOT;?>assets/js/fastclick.js"></script>
        <script src="<?php echo CMS_ROOT;?>assets/js/jquery.slimscroll.js"></script>
        <script src="<?php echo CMS_ROOT;?>assets/js/jquery.blockUI.js"></script>
        <script src="<?php echo CMS_ROOT;?>assets/js/waves.js"></script>
        <script src="<?php echo CMS_ROOT;?>assets/js/wow.min.js"></script>
        <script src="<?php echo CMS_ROOT;?>assets/js/jquery.nicescroll.js"></script>
        <script src="<?php echo CMS_ROOT;?>assets/js/jquery.scrollTo.min.js"></script>
        
        <!-- custom JS by VJ -->
        <script src="<?php echo CMS_ROOT;?>assets/js/custom.js"></script>

        <script src="<?php echo CMS_ROOT;?>assets/js/jquery.core.js"></script>
        <script src="<?php echo CMS_ROOT;?>assets/js/jquery.app.js"></script>
        
        <script type="text/javascript" src="<?php echo CMS_ROOT;?>assets/plugins/parsleyjs/dist/parsley.min.js"></script>
        
        
        <script type="text/javascript">
			$(document).ready(function() {
				$('form').parsley();
			});
		</script>

	</body>
</html>