/*!
 * Cropper v0.7.0
 * https://github.com/fengyuanchen/cropper
 *
 * Copyright 2014 Fengyuan Chen
 * Released under the MIT license
 */

!function(a){"function"==typeof define&&define.amd?define(["jquery"],a):a(jQuery)}(function(a){"use strict";var b=a(window),c=a(document),d=!0,e=!1,f=null,g=0/0,h=1/0,i="undefined",j="directive",k=".cropper",l=/^(e|n|w|s|ne|nw|sw|se|all|crop|move|zoom)$/i,m=/^(x|y|width|height|rotate)$/i,n=/^(naturalWidth|naturalHeight|width|height|aspectRatio|ratio|rotate)$/i,o="cropper-modal",p="cropper-hidden",q="cropper-invisible",r="cropper-move",s="cropper-crop",t="cropper-disabled",u="mousedown touchstart",v="mousemove touchmove",w="mouseup mouseleave touchend touchleave touchcancel",x="wheel mousewheel DOMMouseScroll",y="resize"+k,z="dblclick",A="build"+k,B="built"+k,C="dragstart"+k,D="dragmove"+k,E="dragend"+k,F=function(a){return"number"==typeof a},G=function(a){return'<img src="'+a+'">'},H=function(a){return"rotate("+a+"deg)"},I=function(b,c){this.$element=a(b),this.defaults=a.extend({},I.DEFAULTS,a.isPlainObject(c)?c:{}),this.ready=e,this.built=e,this.cropped=e,this.disabled=e,this.init()},J=Math.round,K=Math.sqrt,L=Math.min,M=Math.max,N=Math.abs,O=parseFloat;I.prototype={constructor:I,init:function(){var b=this.defaults;a.each(b,function(a,c){switch(a){case"aspectRatio":b[a]=N(O(c))||g;break;case"minWidth":case"minHeight":b[a]=N(O(c))||0;break;case"maxWidth":case"maxHeight":b[a]=N(O(c))||h}}),this.load()},load:function(){var b,c,e=this,f=this.$element,g=f[0],h={};f.is("img")?c=f.attr("src"):f.is("canvas")&&g.getContext&&(c=g.toDataURL()),c&&(this.$clone&&this.$clone.remove(),this.$clone=b=a(G(c)),b.one("load",function(){h.naturalWidth=this.naturalWidth||b.width(),h.naturalHeight=this.naturalHeight||b.height(),h.aspectRatio=h.naturalWidth/h.naturalHeight,e.url=c,e.image=h,e.ready=d,e.build()}),b.addClass(q).prependTo("body"))},build:function(){var b,e,f=this.$element,g=this.defaults;this.ready&&(this.built&&this.unbuild(),f.one(A,g.build),b=a.Event(A),f.trigger(b),b.isDefaultPrevented()||(this.$cropper=e=a(I.TEMPLATE),f.addClass(p),this.$clone.removeClass(q).prependTo(e),this.$container=f.parent(),this.$container.append(e),this.$canvas=e.find(".cropper-canvas"),this.$dragger=e.find(".cropper-dragger"),this.$viewer=e.find(".cropper-viewer"),g.autoCrop?this.cropped=d:this.$dragger.addClass(p),g.dragCrop&&this.setDragMode("crop"),g.modal&&this.$canvas.addClass(o),!g.dashed&&this.$dragger.find(".cropper-dashed").addClass(p),!g.movable&&this.$dragger.find(".cropper-face").addClass(p),!g.resizable&&this.$dragger.find(".cropper-line, .cropper-point").addClass(p),this.$dragScope=g.multiple?this.$cropper:c,this.addListeners(),this.initPreview(),this.built=d,this.update(),f.one(B,g.built),f.trigger(B)))},unbuild:function(){this.built&&(this.built=e,this.removeListeners(),this.$preview.empty(),this.$preview=f,this.$dragger=f,this.$canvas=f,this.$container=f,this.$cropper.remove(),this.$cropper=f)},update:function(a){this.initContainer(),this.initCropper(),this.initImage(),this.initDragger(),a?(this.setData(a,d),this.setDragMode("crop")):this.setData(this.defaults.data)},resize:function(){clearTimeout(this.resizing),this.resizing=setTimeout(a.proxy(this.update,this,this.getData()),200)},preview:function(){var b=this.image,c=this.dragger,d=b.width,e=b.height,f=c.left-b.left,g=c.top-b.top,h=b.rotate;this.$viewer.find("img").css({width:J(d),height:J(e),marginLeft:-J(f),marginTop:-J(g),transform:H(h)}),this.$preview.each(function(){var b=a(this),i=b.width()/c.width;b.find("img").css({width:J(d*i),height:J(e*i),marginLeft:-J(f*i),marginTop:-J(g*i),transform:H(h)})})},addListeners:function(){var c=this.$element,d=this.defaults;c.on(C,d.dragstart).on(D,d.dragmove).on(E,d.dragend),this.$cropper.on(u,a.proxy(this.dragstart,this)).on(z,a.proxy(this.dblclick,this)),d.zoomable&&this.$cropper.on(x,a.proxy(this.wheel,this)),this.$dragScope.on(v,a.proxy(this.dragmove,this)).on(w,a.proxy(this.dragend,this)),b.on(y,a.proxy(this.resize,this))},removeListeners:function(){var a=this.$element,c=this.defaults;a.off(C,c.dragstart).off(D,c.dragmove).off(E,c.dragend),this.$cropper.off(u,this.dragstart).off(z,this.dblclick),c.zoomable&&this.$cropper.off(x,this.wheel),this.$dragScope.off(v,this.dragmove).off(w,this.dragend),b.off(y,this.resize)},initPreview:function(){var b=G(this.url);this.$preview=a(this.defaults.preview),this.$preview.html(b),this.$viewer.html(b)},initContainer:function(){var a=this.$container;this.container={width:a.width(),height:a.height()}},initCropper:function(){var a,b=this.container,c=this.image;c.naturalWidth*b.height/c.naturalHeight-b.width>=0?(a={width:b.width,height:b.width/c.aspectRatio,left:0},a.top=(b.height-a.height)/2):(a={width:b.height*c.aspectRatio,height:b.height,top:0},a.left=(b.width-a.width)/2),this.$cropper.css({width:J(a.width),height:J(a.height),left:J(a.left),top:J(a.top)}),this.cropper=a},initImage:function(){var b=this.image,c=this.cropper,d={_width:c.width,_height:c.height,width:c.width,height:c.height,left:0,top:0,ratio:c.width/b.naturalWidth,rotate:0};this.defaultImage=a.extend({},b,d),b._width!==c.width||b._height!==c.height?a.extend(b,d):b=a.extend(d,b),this.image=b,this.renderImage()},renderImage:function(a){var b=this.image;"zoom"===a&&(b.left-=(b.width-b.oldWidth)/2,b.top-=(b.height-b.oldHeight)/2),b.left=L(M(b.left,b._width-b.width),0),b.top=L(M(b.top,b._height-b.height),0),this.$clone.css({width:J(b.width),height:J(b.height),marginLeft:J(b.left),marginTop:J(b.top),transform:H(b.rotate)}),a&&(this.defaults.done(this.getData()),this.preview())},initDragger:function(){var b,c=this.defaults,d=this.cropper,e=c.aspectRatio||this.image.aspectRatio,f=this.image.ratio;b=d.height*e-d.width>=0?{height:d.width/e,width:d.width,left:0,top:(d.height-d.width/e)/2,maxWidth:d.width,maxHeight:d.width/e}:{height:d.height,width:d.height*e,left:(d.width-d.height*e)/2,top:0,maxWidth:d.height*e,maxHeight:d.height},b.minWidth=0,b.minHeight=0,c.aspectRatio?(isFinite(c.maxWidth)?(b.maxWidth=L(b.maxWidth,c.maxWidth*f),b.maxHeight=b.maxWidth/e):isFinite(c.maxHeight)&&(b.maxHeight=L(b.maxHeight,c.maxHeight*f),b.maxWidth=b.maxHeight*e),c.minWidth>0?(b.minWidth=M(0,c.minWidth*f),b.minHeight=b.minWidth/e):c.minHeight>0&&(b.minHeight=M(0,c.minHeight*f),b.minWidth=b.minHeight*e)):(b.maxWidth=L(b.maxWidth,c.maxWidth*f),b.maxHeight=L(b.maxHeight,c.maxHeight*f),b.minWidth=M(0,c.minWidth*f),b.minHeight=M(0,c.minHeight*f)),b.minWidth=L(b.maxWidth,b.minWidth),b.minHeight=L(b.maxHeight,b.minHeight),b.height*=.8,b.width*=.8,b.left=(d.width-b.width)/2,b.top=(d.height-b.height)/2,b.oldLeft=b.left,b.oldTop=b.top,this.defaultDragger=b,this.dragger=a.extend({},b)},renderDragger:function(){var a=this.dragger,b=this.cropper;a.width>a.maxWidth?(a.width=a.maxWidth,a.left=a.oldLeft):a.width<a.minWidth&&(a.width=a.minWidth,a.left=a.oldLeft),a.height>a.maxHeight?(a.height=a.maxHeight,a.top=a.oldTop):a.height<a.minHeight&&(a.height=a.minHeight,a.top=a.oldTop),a.left=L(M(a.left,0),b.width-a.width),a.top=L(M(a.top,0),b.height-a.height),a.oldLeft=a.left,a.oldTop=a.top,this.dragger=a,this.defaults.done(this.getData()),this.$dragger.css({width:J(a.width),height:J(a.height),left:J(a.left),top:J(a.top)}),this.preview()},reset:function(b){this.cropped&&(b&&(this.defaults.data={}),this.image=a.extend({},this.defaultImage),this.renderImage(),this.dragger=a.extend({},this.defaultDragger),this.setData(this.defaults.data))},clear:function(){this.cropped&&(this.cropped=e,this.setData({x:0,y:0,width:0,height:0,rotate:0}),this.$canvas.removeClass(o),this.$dragger.addClass(p))},destroy:function(){var a=this.$element;this.ready&&(this.unbuild(),a.removeClass(p),a.removeData("cropper"))},replace:function(b){var c,d=this,e=this.$element,f=e[0];b&&b!==this.url&&(e.is("img")?(e.attr("src",b),this.load()):e.is("canvas")&&f.getContext&&(c=f.getContext("2d"),a(G(b)).one("load",function(){f.width=this.width,f.height=this.height,c.clearRect(0,0,f.width,f.height),c.drawImage(this,0,0),d.load()})))},setData:function(b,c){var d=this.cropper,e=this.dragger,g=this.image,h=this.defaults.aspectRatio;this.built&&typeof b!==i&&((b===f||a.isEmptyObject(b))&&(e=a.extend({},this.defaultDragger)),a.isPlainObject(b)&&!a.isEmptyObject(b)&&(c||(this.defaults.data=b),b=this.transformData(b),F(b.x)&&b.x<=d.width-g.left&&(e.left=b.x+g.left),F(b.y)&&b.y<=d.height-g.top&&(e.top=b.y+g.top),h?F(b.width)&&b.width<=e.maxWidth&&b.width>=e.minWidth?(e.width=b.width,e.height=e.width/h):F(b.height)&&b.height<=e.maxHeight&&b.height>=e.minHeight&&(e.height=b.height,e.width=e.height*h):(F(b.width)&&b.width<=e.maxWidth&&b.width>=e.minWidth&&(e.width=b.width),F(b.height)&&b.height<=e.maxHeight&&b.height>=e.minHeight&&(e.height=b.height)),F(b.rotate)&&this.rotate(b.rotate)),this.dragger=e,this.renderDragger())},getData:function(){var a=this.dragger,b=this.image,c={};return this.built&&(c={x:a.left-b.left,y:a.top-b.top,width:a.width,height:a.height,rotate:b.rotate},c=this.transformData(c,d)),c},transformData:function(b,c){var d=this.image.ratio,e={};return a.each(b,function(a,b){b=O(b),m.test(a)&&!isNaN(b)&&(e[a]="rotate"===a?b:c?J(b/d):b*d)}),e},setAspectRatio:function(a){var b="auto"===a;a=O(a),(b||!isNaN(a)&&a>0)&&(this.defaults.aspectRatio=b?g:a,this.built&&(this.initDragger(),this.renderDragger()))},getImageData:function(){var b={};return this.ready&&a.each(this.image,function(a,c){n.test(a)&&(b[a]=c)}),b},getDataURL:function(a,b){var c=this.getData(),d=this.$clone[0],e=document.createElement("canvas"),f="";return this.cropped&&e.getContext&&(e.width=c.width,e.height=c.height,e.getContext("2d").drawImage(d,c.x,c.y,c.width,c.height,0,0,c.width,c.height),f=e.toDataURL(a,b)),f},setDragMode:function(a){var b=this.$canvas,c=this.defaults,f=e,g=e;if(!this.disabled){switch(a){case"crop":c.dragCrop&&(f=d,b.data(j,a));break;case"move":c.movable&&(g=d,b.data(j,a));break;default:b.removeData(j)}b.toggleClass(s,f).toggleClass(r,g)}},enable:function(){this.disabled=e,this.$cropper.removeClass(t)},disable:function(){this.disabled=d,this.$cropper.addClass(t)},rotate:function(a){var b;!this.disabled&&this.defaults.rotatable&&(b=this.image.rotate+(O(a)||0),this.image.rotate=b%360,this.renderImage("rotate"))},zoom:function(a){var b,c,d,e;!this.disabled&&this.defaults.zoomable&&(b=this.image,c=b.width*(1+a),d=b.height*(1+a),e=c/b._width,e>10||(1>e&&(c=b._width,d=b._height),this.setDragMode(1>=e?"crop":"move"),b.oldWidth=b.width,b.oldHeight=b.height,b.width=c,b.height=d,b.ratio=b.width/b.naturalWidth,this.renderImage("zoom")))},dblclick:function(){this.disabled||this.setDragMode(this.$canvas.hasClass(s)?"move":"crop")},wheel:function(a){var b,c=a.originalEvent,d=117.25,e=5,f=166.66665649414062,g=.1;this.disabled||(a.preventDefault(),c.deltaY?(b=c.deltaY,b=b%e===0?b/e:b%d===0?b/d:b/f):b=c.wheelDelta?-c.wheelDelta/120:c.detail?c.detail/3:0,this.zoom(b*g))},dragstart:function(b){var c,f,g,h=b.originalEvent.touches,i=b;if(!this.disabled){if(h){if(g=h.length,g>1){if(!this.defaults.zoomable||2!==g)return;i=h[1],this.startX2=i.pageX,this.startY2=i.pageY,c="zoom"}i=h[0]}if(c=c||a(i.target).data(j),l.test(c)){if(b.preventDefault(),f=a.Event(C),this.$element.trigger(f),f.isDefaultPrevented())return;this.directive=c,this.cropping=e,this.startX=i.pageX,this.startY=i.pageY,"crop"===c&&(this.cropping=d,this.$canvas.addClass(o))}}},dragmove:function(b){var c,d,e=b.originalEvent.touches,f=b;if(!this.disabled){if(e){if(d=e.length,d>1){if(!this.defaults.zoomable||2!==d)return;f=e[1],this.endX2=f.pageX,this.endY2=f.pageY}f=e[0]}if(this.directive){if(b.preventDefault(),c=a.Event(D),this.$element.trigger(c),c.isDefaultPrevented())return;this.endX=f.pageX,this.endY=f.pageY,this.dragging()}}},dragend:function(b){var c;if(!this.disabled&&this.directive){if(b.preventDefault(),c=a.Event(E),this.$element.trigger(c),c.isDefaultPrevented())return;this.cropping&&(this.cropping=e,this.$canvas.toggleClass(o,this.cropped&&this.defaults.modal)),this.directive=""}},dragging:function(){var a,b=this.directive,c=this.image,f=this.cropper,g=f.width,h=f.height,i=this.dragger,j=i.width,k=i.height,l=i.left,m=i.top,n=l+j,o=m+k,q=d,r=this.defaults,s=r.aspectRatio,t={x:this.endX-this.startX,y:this.endY-this.startY};switch(s&&(t.X=t.y*s,t.Y=t.x/s),b){case"all":l+=t.x,m+=t.y;break;case"e":if(t.x>=0&&(n>=g||s&&(0>=m||o>=h))){q=e;break}j+=t.x,s&&(k=j/s,m-=t.Y/2),0>j&&(b="w",j=0);break;case"n":if(t.y<=0&&(0>=m||s&&(0>=l||n>=g))){q=e;break}k-=t.y,m+=t.y,s&&(j=k*s,l+=t.X/2),0>k&&(b="s",k=0);break;case"w":if(t.x<=0&&(0>=l||s&&(0>=m||o>=h))){q=e;break}j-=t.x,l+=t.x,s&&(k=j/s,m+=t.Y/2),0>j&&(b="e",j=0);break;case"s":if(t.y>=0&&(o>=h||s&&(0>=l||n>=g))){q=e;break}k+=t.y,s&&(j=k*s,l-=t.X/2),0>k&&(b="n",k=0);break;case"ne":if(t.y<=0&&(0>=m||n>=g)){q=e;break}k-=t.y,m+=t.y,s?j=k*s:j+=t.x,0>k&&(b="sw",k=0,j=0);break;case"nw":if(t.y<=0&&(0>=m||0>=l)){q=e;break}k-=t.y,m+=t.y,s?(j=k*s,l+=t.X):(j-=t.x,l+=t.x),0>k&&(b="se",k=0,j=0);break;case"sw":if(t.x<=0&&(0>=l||o>=h)){q=e;break}j-=t.x,l+=t.x,s?k=j/s:k+=t.y,0>j&&(b="ne",k=0,j=0);break;case"se":if(t.x>=0&&(n>=g||o>=h)){q=e;break}j+=t.x,s?k=j/s:k+=t.y,0>j&&(b="nw",k=0,j=0);break;case"move":c.left+=t.x,c.top+=t.y,this.renderImage("move"),q=e;break;case"zoom":r.zoomable&&(this.zoom(function(a,b,c,d,e,f){return(K(e*e+f*f)-K(c*c+d*d))/K(a*a+b*b)}(c.width,c.height,N(this.startX-this.startX2),N(this.startY-this.startY2),N(this.endX-this.endX2),N(this.endY-this.endY2))),this.endX2=this.startX2,this.endY2=this.startY2);break;case"crop":t.x&&t.y&&(a=this.$cropper.offset(),l=this.startX-a.left,m=this.startY-a.top,j=i.minWidth,k=i.minHeight,t.x>0?t.y>0?b="se":(b="ne",m-=k):t.y>0?(b="sw",l-=j):(b="nw",l-=j,m-=k),this.cropped||(this.cropped=d,this.$dragger.removeClass(p)))}q&&(i.width=j,i.height=k,i.left=l,i.top=m,this.directive=b,this.renderDragger()),this.startX=this.endX,this.startY=this.endY}},I.TEMPLATE=function(a,b){return b=b.split(","),a.replace(/\d+/g,function(a){return b[a]})}('<0 6="5-container"><0 6="5-canvas"></0><0 6="5-dragger"><1 6="5-viewer"></1><1 6="5-8 8-h"></1><1 6="5-8 8-v"></1><1 6="5-face" 3-2="all"></1><1 6="5-7 7-e" 3-2="e"></1><1 6="5-7 7-n" 3-2="n"></1><1 6="5-7 7-w" 3-2="w"></1><1 6="5-7 7-s" 3-2="s"></1><1 6="5-4 4-e" 3-2="e"></1><1 6="5-4 4-n" 3-2="n"></1><1 6="5-4 4-w" 3-2="w"></1><1 6="5-4 4-s" 3-2="s"></1><1 6="5-4 4-ne" 3-2="ne"></1><1 6="5-4 4-nw" 3-2="nw"></1><1 6="5-4 4-sw" 3-2="sw"></1><1 6="5-4 4-se" 3-2="se"></1></0></0>',"div,span,directive,data,point,cropper,class,line,dashed"),I.DEFAULTS={aspectRatio:"auto",data:{},done:a.noop,preview:"",multiple:e,autoCrop:d,dragCrop:d,dashed:d,modal:d,movable:d,resizable:d,zoomable:d,rotatable:d,minWidth:0,minHeight:0,maxWidth:h,maxHeight:h,build:f,built:f,dragstart:f,dragmove:f,dragend:f},I.setDefaults=function(b){a.extend(I.DEFAULTS,b)},I.other=a.fn.cropper,a.fn.cropper=function(b){var c,d=[].slice.call(arguments,1);return this.each(function(){var e,f=a(this),g=f.data("cropper");g||f.data("cropper",g=new I(this,b)),"string"==typeof b&&a.isFunction(e=g[b])&&(c=e.apply(g,d))}),typeof c!==i?c:this},a.fn.cropper.constructor=I,a.fn.cropper.setDefaults=I.setDefaults,a.fn.cropper.noConflict=function(){return a.fn.cropper=I.other,this}});