/**
* Theme: Ubold Admin Template
* Author: Coderthemes
* Form wizard page
*/

!function($) {
    "use strict";

    var FormWizard = function() {};

    FormWizard.prototype.createBasic = function($form_container) {
        $form_container.children("div").steps({
            headerTag: "h3",
            bodyTag: "section",
            transitionEffect: "slideLeft",
			onStepChanging: function (event, currentIndex, newIndex) {
				var siteurl = $('#siteurl').val();
				$form_container.validate().settings.ignore = ":disabled,:hidden";
                if(($form_container.valid()==true && currentIndex==0) || ($form_container.valid()==true && currentIndex==1)) {
					//var string = $( '.exp_form' ).serialize();//'width='+ width + '&action=registrationform';
					//var stringIndex = string+'&cuurentIndex='+currentIndex;
					//($form_container.valid()==true && currentIndex==1)
					var form = $('.exp_form')[0];
					$.ajax({
						type: 'POST',
						url: siteurl+'includes/process.php',
						async: true,
						contentType: false,
						cache: false,
						processData:false,
						data: new FormData(form),
						success: function(data)	{
							var dataa = $.trim(data);
							var arr = dataa.split('-');
							if(arr[0]=="introId") {
								$('#intro_id').val(arr[1]);
							}
							if(currentIndex==0) {
								swal("Success", "Tour introduction saved succefully.", "success");
							}
							if(currentIndex==1) {
								swal("Success", "Poi saved succefully.", "success");
							}
						}
					});
				}
				
				if(currentIndex==1) {
					var poia = $('#edit_poi option:selected').val();
					var optionLen  = $('#edit_poi > option').length;
					if(poia=="" && optionLen>1) {
						return true;
					} else if(optionLen>1) {
						return true;
					}else {
						return false;
					}
				}
				
				if (currentIndex > newIndex)
				{
					var $cropper = $(".cropper"),
                        $dataX = $("#dataX"),
                        $dataY = $("#dataY"),
                        $dataHeight = $("#dataHeight"),
                        $dataWidth = $("#dataWidth"),
                        $dataRotate = $("#dataRotate"),
					console = window.console || {log: $.noop},
					cropper;

					$cropper.cropper({
						aspectRatio: 16 / 9,
						data: {
							x: 220,
							y: 50,
							width: 340,
							height: 160
						},
						preview: ".preview",
		
						// autoCrop: false,
						// dragCrop: false,
						// modal: false,
						// moveable: false,
						// resizeable: false,
						// scalable: false,
		
						// maxWidth: 480,
						// maxHeight: 270,
						// minWidth: 160,
						// minHeight: 90,
		
						done: function (data) {
							$dataX.val(data.x);
							$dataY.val(data.y);
							$dataHeight.val(data.height);
							$dataWidth.val(data.width);
							$dataRotate.val(data.rotate);
						},
						build: function (e) {
							console.log(e.type);
						},
						built: function (e) {
							console.log(e.type);
						},
						dragstart: function (e) {
							console.log(e.type);
						},
						dragmove: function (e) {
							console.log(e.type);
						},
						dragend: function (e) {
							console.log(e.type);
						}
					});
		
					cropper = $cropper.data("cropper");
		
					$cropper.on({
						"build.cropper": function (e) {
							console.log(e.type);
							// e.preventDefault();
						},
						"built.cropper": function (e) {
							console.log(e.type);
							// e.preventDefault();
						},
						"dragstart.cropper": function (e) {
							console.log(e.type);
							// e.preventDefault();
						},
						"dragmove.cropper": function (e) {
							console.log(e.type);
							// e.preventDefault();
						},
						"dragend.cropper": function (e) {
							console.log(e.type);
							// e.preventDefault();
						}
					});
					$("#zoomIn").click(function () {
						$cropper.cropper("zoom", 0.1);
					});
	
					$("#zoomOut").click(function () {
						$cropper.cropper("zoom", -0.1);
					});
	
					$("#rotateLeft").click(function () {
						$cropper.cropper("rotate", -90);
					});
	
					$("#rotateRight").click(function () {
						$cropper.cropper("rotate", 90);
					});
	
					$("#getData").click(function () {
						$("#showData").val(JSON.stringify($cropper.cropper("getData")));
					});
	
					$("#getDataURL").click(function () {
						var dataURL = $cropper.cropper("getDataURL", "image/jpeg");
						$("#intro_dataURL").val(dataURL);
						$("#showDataURL").html('<img src="' + dataURL + '">');
						$('#previewing').hide();
						$('#buttongroup').hide();
					});
	
					$("#getDataURL2").click(function () {
						var dataURL = $cropper.cropper("getDataURL", "image/jpeg");
	
						$("#dataURL").text(dataURL);
						$("#showDataURL").html('<img src="' + dataURL + '">');
						$('#previewing').hide();
						$('#buttongroup').hide();
					});
					
					$('#cropagain').click(function() {
						$('#previewing').show();
						$('#buttongroup').show();
					});
					return true;
				} else {
					initialize();
					var $croppera = $(".croppera"),
                        $dataXa = $("#dataXa"),
                        $dataYa = $("#dataYa"),
                        $dataHeighta = $("#dataHeighta"),
                        $dataWidtha = $("#dataWidtha"),
                        $dataRotatea = $("#dataRotatea"),
					console = window.console || {log: $.noop},
					cropper;

					$croppera.cropper({
						aspectRatio: 16 / 9,
						data: {
							x: 220,
							y: 50,
							width: 340,
							height: 160
						},
						preview: ".preview",
		
						// autoCrop: false,
						// dragCrop: false,
						// modal: false,
						// moveable: false,
						// resizeable: false,
						// scalable: false,
		
						// maxWidth: 480,
						// maxHeight: 270,
						// minWidth: 160,
						// minHeight: 90,
		
						done: function (data) {
							$dataXa.val(data.x);
							$dataYa.val(data.y);
							$dataHeighta.val(data.height);
							$dataWidtha.val(data.width);
							$dataRotatea.val(data.rotate);
						},
						build: function (e) {
							console.log(e.type);
						},
						built: function (e) {
							console.log(e.type);
						},
						dragstart: function (e) {
							console.log(e.type);
						},
						dragmove: function (e) {
							console.log(e.type);
						},
						dragend: function (e) {
							console.log(e.type);
						}
					});
		
					cropper = $croppera.data("cropper");
		
					$croppera.on({
						"build.cropper": function (e) {
							console.log(e.type);
							// e.preventDefault();
						},
						"built.cropper": function (e) {
							console.log(e.type);
							// e.preventDefault();
						},
						"dragstart.cropper": function (e) {
							console.log(e.type);
							// e.preventDefault();
						},
						"dragmove.cropper": function (e) {
							console.log(e.type);
							// e.preventDefault();
						},
						"dragend.cropper": function (e) {
							console.log(e.type);
							// e.preventDefault();
						}
					});
					
					$("#zoomIna").click(function () {
                    $croppera.cropper("zoom", 0.1);
                });

                $("#zoomOuta").click(function () {
                    $croppera.cropper("zoom", -0.1);
                });

                $("#rotateLefta").click(function () {
                    $croppera.cropper("rotate", -90);
                });

                $("#rotateRighta").click(function () {
                    $croppera.cropper("rotate", 90);
                });

                $("#getDataa").click(function () {
                    $("#showDataa").val(JSON.stringify($croppera.cropper("getData")));
                });

                $("#getDataURLa").click(function () {
					var dataURL = $croppera.cropper("getDataURL");
					$("#poi_dataURLa").val(dataURL);
                    $("#showDataURLa").html('<img src="' + dataURL + '">');
					$('#previewinga').hide();
					$('#buttongroupa').hide();
                });

                $("#getDataURL2a").click(function () {
                    var dataURL = $croppera.cropper("getDataURL", "image/jpeg");

                    $("#dataURLa").text(dataURL);
                    $("#showDataURLa").html('<img src="' + dataURL + '">');
					$('#previewinga').hide();
					$('#buttongroupa').hide();
                });
				return $form_container.valid();	
				}
				//$form_container.valid();
				//return true;
            },
            onFinishing: function (event, currentIndex) { 
                //NOTE: Here you can do form validation and return true or false based on your validation logic
                console.log("Form has been validated!");
                return true; 
            }, 
            onFinished: function (event, currentIndex) {
               //NOTE: Submit the form, if all validation passed.
                console.log("Form can be submitted using submit method. E.g. $('#basic-form').submit()"); 
                //$("#basic-form").submit();
				var siteurl = $('#siteurl').val();
				var visibility = $('input[name=visibility]:checked').val();
				var introStatus = $('#intro_status option:selected').attr('value');
				var dataString = "visibility="+visibility+"&introStatus="+introStatus+"&introId="+$('#intro_id').val()+"&action=final";
				$.ajax({
					type: 'POST',
					url: siteurl+'includes/process.php',
					data: dataString,
					success: function(data)	{
						swal({
							title: "Published",
							type: "success",
							text: "I will close in 4 seconds.",
							timer: 4000,
							showConfirmButton: false
						}).then(
						  function () {},
						  // handling the promise rejection
						  function (dismiss) {
							if (dismiss === 'timer') {
							  //console.log('I was closed by the timer')
							  window.location.href = siteurl+"manage_exp.php";
							}
						  }
						)
						
					}
				});

            }
        });
        return $form_container;
    },
    //creates form with validation
    FormWizard.prototype.createValidatorForm = function($form_container) {
        $form_container.validate({
            errorPlacement: function errorPlacement(error, element) {
                element.after(error);
            }
        });
        $form_container.children("div").steps({
            headerTag: "h3",
            bodyTag: "section",
            transitionEffect: "slideLeft",
            onStepChanging: function (event, currentIndex, newIndex) {
				$form_container.validate().settings.ignore = ":disabled,:hidden";
                return $form_container.valid();
            },
            onFinishing: function (event, currentIndex) {
                $form_container.validate().settings.ignore = ":disabled";
                return $form_container.valid();
            },
            onFinished: function (event, currentIndex) {
                alert("Submitted!");
            }
        });

        return $form_container;
    },
    //creates vertical form
    FormWizard.prototype.createVertical = function($form_container) {
        $form_container.steps({
            headerTag: "h3",
            bodyTag: "section",
            transitionEffect: "fade",
            stepsOrientation: "vertical"
        });
        return $form_container;
    },
    FormWizard.prototype.init = function() {
        //initialzing various forms

        //basic form
        this.createBasic($("#basic-form"));

        //form with validation
        this.createValidatorForm($("#wizard-validation-form"));

        //vertical form
        this.createVertical($("#wizard-vertical"));
    },
    //init
    $.FormWizard = new FormWizard, $.FormWizard.Constructor = FormWizard
}(window.jQuery),

//initializing 
function($) {
    "use strict";
    $.FormWizard.init()
}(window.jQuery);